#include "stdafx.h"
#include "objectloader.h"
#include "triangleobject.h"

#include <GL/glut.h>
#include <stdlib.h>
#include <time.h>

CString g_sApplicationPath;
CTriangleObject myProEObject;

float fRotY = 0.0f;
float fRotX = 0.0f;

bool bAlak = true;

void display(void)
	{
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glColor3f (1.0, 1.0, 1.0);
   glLoadIdentity ();             // egysgmtrix
   //
	// nzpont transzformci viewing transformation 
	// 
 	glTranslatef(0.0,0.0, -800.0);
	glRotatef(fRotY, 0.0f, 1.0f, 0.0f); 
	glRotatef(fRotX, 1.0f, 0.0f, 0.0f); 
	//
	// model transformacio
	//
	if (bAlak)
		{
		myProEObject.Show("..\\alakzat2.slp");
		}
	else
		{
		myProEObject.Show("..\\alakzat.slp");
		}

	glutSwapBuffers();
	}
//
// viewport, projekci, s transformci
//
void reshape (int w, int h)
	{
   glViewport (0, 0, w, h); 
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
	gluPerspective (60.0, 1.0, 10.0, 1000.0);
	glMatrixMode (GL_MODELVIEW);

	glCullFace(GL_BACK);
	glEnable(GL_CULL_FACE);
	glEnable(GL_DEPTH_TEST);	
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_NORMALIZE);
	
	float fvLightAmbient[] = {0.3f, 0.4f, 0.5f, 1.0f};
	float m_fvLightPos[] = {100.0, 100.0, 100.0, 0.0};

	glLightModelfv(GL_LIGHT_MODEL_AMBIENT,fvLightAmbient);	
	glLightfv(GL_LIGHT0,GL_POSITION,m_fvLightPos);
	}

void keyboard(unsigned char key, int x, int y)
	{
   switch (key) 
		{
      case 'w':
			fRotX += 5.0f;
      break;
		case 's':
			fRotX -= 5.0f;
      break;
      case 'a':
			fRotY -= 5;
      break;
		case 'd':
			fRotY += 5;
      break;
      case 'y':
			bAlak = !bAlak;
      break;

		}
	glutPostRedisplay();	
	}

int main()
	{
	TCHAR szFullPath[MAX_PATH];
	//
	// get apps full path 
	//
	::GetModuleFileName(NULL, szFullPath, MAX_PATH);
	g_sApplicationPath = szFullPath;
	g_sApplicationPath = g_sApplicationPath.Mid(0,g_sApplicationPath.Find("objectloader"));
	//
	// load objects
	//
	myProEObject.LoadTriangleFile("..\\alakzat.slp");
	myProEObject.LoadTriangleFile("..\\alakzat2.slp");

	glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB);
   glutInitWindowSize (600, 600); 
   glutCreateWindow ("Teglatest Rajzolasa");
   glutDisplayFunc(display); 
   glutReshapeFunc(reshape);
	glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
	}


